#ifndef RWEXP_MAXNATIVESKIN_H
#define RWEXP_MAXNATIVESKIN_H

#include "RwExpError.h"

extern Modifier * 
FindBonesDefModifier (INode* nodePtr);

extern INode * 
FindFirstMaxSkinNode(INode* nodePtr);

extern INode *
FindMaxBonesHierarchy(INode *skinNode);

extern bool
NodeContainsBones(INode* Node);

extern RwExpError
FindMaxSkinAndBonesNodes(
    INode *sceneRoot,               //input - root of entire MAX scene.
    INode *topOfSelectedHierarchy,  //input - highest node in heirarchy user selected.
    INode * &maxSkinNode,           //output - node with a max skin modifier with some relation to selected node.
    INode * &topOfMaxBonesNodes     //output - node with max bones for that skin.
    );

#endif

